#include <stdio.h>
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "Arduino.h"
#include "Wire.h"
#include "kidbright32.h"
#include "ports.h"
#include "button12.h"
#include "ldr.h"
#include "sound.h"
#include "ht16k33.h"
#include "lm73.h"
#include "mcp7940n.h"

#include "nvs_flash.h"
#include "wificontroller.h"
#include "kbiot.h"

#define KBSERIAL "B4E62D95512D"
#define CLIENTID "B4E62D95512D"
#define USERNAME "c812d6a303c1771a262d76cbd1f0fac0"
#define PASSWORD ""
#define CONFIG_WIFI_SSID "faIphone"
#define CONFIG_WIFI_PASSWORD "ple4good"

extern PORTS ports;
extern BUTTON12 button12;
extern LDR ldr;
extern SOUND sound;
extern HT16K33 ht16k33;
extern LM73 lm73_0;
extern LM73 lm73_1;
extern MCP7940N mcp7940n;


void user_app(void) {
wifi_sta_start(CONFIG_WIFI_SSID, CONFIG_WIFI_PASSWORD);
kbiot_init(KBSERIAL, CLIENTID, USERNAME, PASSWORD);

  // setup
  while(1) {
    ht16k33.show((uint8_t *)"\x0\x0\x0\x0\x0\x80\x80\x0\x0\x0\x0\x0\x0\x0\x0\x0");
    kbiot_setValue_float("G1", (lm73_0.error() ? lm73_1.get() : lm73_0.get()));
    vTaskDelay(1000 / portTICK_RATE_MS);
  }
  
  // create tasks
}
