const tools = require('./jsontools')
const fs = require('fs')
const pathlis = require('./pathlist')
const unzip = require('unzip-stream')
const download = require('download')
const del = require('del')
const copyfile = require('./copyfile')
const fixport = require('./fixport').doSerialport

function downloadjson(cb) {
    download(jsondownload, tempdir).then(() => {
        console.log('done!')
        cb()
    })
}

function comparejson(cb) {
    var jsontemp, jsonorigin
    tools.readfilejson(kbtemp, (json) => {
        console.log(json)
        jsontemp = json
        tools.readfilejson(kbide32json, (json) => {
            jsonorigin = json
            tools.checksamejson(jsontemp, jsonorigin, (status) => {
                cb(status, jsontemp, jsonorigin)
            })
        })
    })
}

function doUpdates(cb) {
    downloadjson(() => {
        comparejson((status, jsontemp, jsonorigin) => {
            checkUpdates(status, jsontemp, jsonorigin, () => {
                if (status === false) {
                    checkDownloadApp(jsontemp, jsonorigin, () => {
                        checkDownloadEsp32(jsontemp, jsonorigin, () => {
                            doCopy(kbtemp, archivepath, () => {
                                del([gitdir]).then(() => {
                                    console.log('updates success')
                                    cb()
                                })
                                fixport()
                                console.log('updates success')
                                cb()
                            })
                        })
                    })
                }
                else {
                    cb()
                }
            })
        })
    })
}
module.exports.doUpdates = doUpdates

function checkUpdates(status, jsontemp, jsonorigin, cb) {
    if (status === true) {
        del([tempdir]).then(() => {
            console.log('no updates')
            cb()
        })
    }
    else {
        console.log('updates')
        cb()
    }
}

function checkDownloadApp(jsontemp, jsonorigin, cb) {
    if (JSON.stringify(jsontemp.packages[3]) !== JSON.stringify(jsonorigin.packages[3])) {
        console.log('app downloading')
        download(appdownload, tempdir).then(() => {
            fs.createReadStream(apptemp).pipe(unzip.Extract({ path: outputapp })).on('close', () => {
                if (process.platform === 'win32') {
                    doCopy(copyapp, apppath, () => {
                        console.log('App done!')
                        cb()
                    })
                }
                else {
                    doCopy(copyapp, kbidepath, () => {
                        console.log('App done!')
                        cb()
                    })
                }
            })
        })
    }
    else {
        cb()
    }
}

function checkDownloadEsp32(jsontemp, jsonorigin, cb) {
    if (JSON.stringify(jsontemp.packages[4]) !== JSON.stringify(jsonorigin.packages[4])) {
        console.log('esp32 downloading')
        download(esp32download, tempdir).then(() => {
            console.log('esp32 downloaded')
            fs.createReadStream(esp32temp).pipe(unzip.Extract({ path: ouputesp32 })).on('close', () => {
                if (process.platform === 'win32') {
                    doCopy(copysp32, esp32path, () => {
                        console.log('ESP32 done!')
                        cb()
                    })
                }
                else {
                    doCopy(copysp32, kbidepath, () => {
                        console.log('ESP32 done!')
                        cb()
                    })
                }
            })
        })
    }
    else {
        cb()
    }
}

function doCopy(oldpath, newpath, cb) {
    if (process.platform === 'win32') {
        copyfile.copywin(oldpath, newpath, () => {
            cb()
        })
    }
    else {
        copyfile.copyunix(oldpath, newpath, () => {
            cb()
        })
    }
}
