const { app, BrowserWindow, Menu } = require('electron')
const ProgressBar = require('electron-progressbar');
const path = require('path')
const console = require('console');
const updates = require('./utils/updates').doUpdates
const connected = require('./utils/connectionCheck').checkConnection

if (require('electron-squirrel-startup')) app.quit()
// if first time install on windows, do not run application, rather
// let squirrel installer do its work
if (handleSquirrelEvent()) {
  process.exit()
}

const template = [
  {
    label: 'File',
    submenu: [
      { role: 'minimize' },
      { role: 'close' }
    ]
  },
  {
    label: 'View',
    submenu: [
      { role: 'resetzoom' },
      { role: 'zoomin' },
      { role: 'zoomout' },
      { type: 'separator' },
      { role: 'togglefullscreen' }
    ]
  },
  {
    role: 'help',
    submenu: [
      {
        label: 'Learn More',
        click() { require('electron').shell.openExternal('https://www.kid-bright.org') }
      },
      {
        label: 'Check for update'
      }
    ]
  }
]

if (process.platform === 'darwin') {
  template.unshift({
    label: app.getName(),
    submenu: [
      { role: 'about' },
      { type: 'separator' },
      { role: 'services', submenu: [] },
      { type: 'separator' },
      { role: 'hide' },
      { role: 'hideothers' },
      { role: 'unhide' },
      { type: 'separator' },
      { role: 'quit' }
    ]
  })

  // Edit menu
  template[1].submenu.push(
    { type: 'separator' },
    {
      label: 'Speech',
      submenu: [
        { role: 'startspeaking' },
        { role: 'stopspeaking' }
      ]
    }
  )

  // Window menu
  template[3].submenu = [
    { role: 'close' },
    { role: 'minimize' },
    { role: 'zoom' },
    { type: 'separator' },
    { role: 'front' }
  ]
}

const menu = Menu.buildFromTemplate(template)
Menu.setApplicationMenu(menu)

app.console = new console.Console(process.stdout, process.stderr);

const serverPath = __dirname + '/kbide/app'

const server = require(serverPath + '/index.js');
server.init(__dirname + '/kbide', true);

app.on('ready', () => {
  progressing(() => {
    win = new BrowserWindow({
      width: 1280,
      height: 720,
      webPreferences: {
        nodeIntegration: false
      },
      icon: path.join(__dirname, 'assets/icons/Icon-64.png')
    })
    // win.setMenu(null) 
    var config = require(serverPath + '/config.json')
    console.log(config.webserver.port)

    win.loadURL('http://localhost:' + config.webserver.port)
    console.log(__dirname)
  })
});

app.on('before-quit', function () {
  app.console.log("before quit")
});

app.on('window-all-closed', function () {
  app.console.log("windows closed")
  app.exit()
});


async function progressing(cb) {
  if (await connected()) {
    var progressBar = new ProgressBar();
    progressBar.title = 'Checking for Updates'
    progressBar.text = 'Program Updating...'

    progressBar
      .on('completed', function () {
        console.info(`completed...`);
        progressBar.detail = 'Task completed. Exiting...';
      })
      .on('aborted', function () {
        console.info(`aborted...`);
      });

    updates(() => {
      progressBar.setCompleted()
      cb()
    })
  }
  else cb()
}

function handleSquirrelEvent() {
  if (process.argv.length === 1) {
    return false;
  }

  const ChildProcess = require('child_process');
  const path = require('path');

  const appFolder = path.resolve(process.execPath, '..');
  const rootAtomFolder = path.resolve(appFolder, '..');
  const updateDotExe = path.resolve(path.join(rootAtomFolder, 'Update.exe'));
  const exeName = path.basename(process.execPath);

  const spawn = function (command, args) {
    let spawnedProcess, error;

    try {
      spawnedProcess = ChildProcess.spawn(command, args, { detached: true });
    } catch (error) { }

    return spawnedProcess;
  };

  const spawnUpdate = function (args) {
    return spawn(updateDotExe, args);
  };

  const squirrelEvent = process.argv[1];
  switch (squirrelEvent) {
    case '--squirrel-install':
    case '--squirrel-updated':
      // Optionally do things such as:
      // - Add your .exe to the PATH
      // - Write to the registry for things like file associations and
      //   explorer context menus

      // Install desktop and start menu shortcuts
      spawnUpdate(['--createShortcut', exeName]);

      setTimeout(app.quit, 1000);
      return true;

    case '--squirrel-uninstall':
      // Undo anything you did in the --squirrel-install and
      // --squirrel-updated handlers

      // Remove desktop and start menu shortcuts
      spawnUpdate(['--removeShortcut', exeName]);

      setTimeout(app.quit, 1000);
      return true;

    case '--squirrel-obsolete':
      // This is called on the outgoing version of your app before
      // we update to the new version - it's the opposite of
      // --squirrel-updated

      app.quit();
      return true;
  }
};
