const git = require('./git')
const zip = require('./zip')
const md5 = require('./gen').md5
const tools = require('./jsontools')
const fs = require('fs')
const pathlist = require('./pathlist')
const copyfile = require('./copyfile')

function checkExistRelease(cb) {
    if (!fs.existsSync(gitdir)) {
        git.clone(gitpath, () => {
            cb()
        })
    }
    else {
        git.pull(gitdir, () => {
            cb()
        })
    }
}

function doZip(cb) {
    zip.file(apppath, fs.createWriteStream(appzip), (res) => {
        zip.file(esp32path, fs.createWriteStream(esp32zip), (res) => {
            cb()
        })
    })
}

function updateJson(cb) {
    tools.readfilejson(kbide32json, (json) => {
        tools.updatemd5(json.packages[3].items, 'app', md5())
        tools.updatemd5(json.packages[4].items, 'esp32', md5())
        tools.updatefilejson(kbide32json, json)
        cb()
    })
}

function copyjson() {
    if (process.platform === 'win32') {
        copyfile.copywin(kbide32json, gitdir, () => {
        })
    }
    else {
        copyfile.copyunix(kbide32json, gitdir, () => {
        })
    }
}

function doRelease() {
    checkExistRelease(() => {
        updateJson(() => {
            copyjson()
        })
        doZip(() => {
            doGit(() => {
            })
        })
    })
}

function doGit() {
    git.add(gitdir, () => {
        git.commit(gitdir, () => {
            git.push(gitdir, () => {
            })
        })
    })
}

doRelease()