const cp = require('child_process')
const logExec = require('./logexe').logExec

function clone(pathgit, cb) {
    cp.execSync('cd .. && git clone ' + pathgit)
    cb()
}
module.exports.clone = clone

function add(pathgit, cb) {
    cp.execSync('cd ' + pathgit + ' && git add .')
    cb()
}
module.exports.add = add

function commit(pathgit, cb) {
    cp.execSync('cd ' + pathgit + ' && git commit -m "new release"')
    cb()
}
module.exports.commit = commit

function push(pathgit, cb) {
    cp.execSync('cd ' + pathgit + ' && git push')
    cb()
}
module.exports.push = push

function pull(pathgit, cb) {
    cp.execSync('cd ' + pathgit + ' && git pull')
    cb()
}
module.exports.pull = pull

function name(pathgit) {
    const lastslash = pathgit.lastIndexOf('/') + 1
    const pathlength = pathgit.length
    const gitname = pathgit.substring(lastslash, pathlength).split('.')[0]
    return gitname
}
module.exports.name = name

// test
// var gitpath = "https://gitlab.com/zCaesar/netpie.git"
// const movefile = require('../utils/movefile')
// const path = require('path')
// const apath = path.join(__dirname, '/a')
// const netpiepath = path.join(__dirname, '/netpie')

// gitclone(gitpath, (res) => {
//     if (res === true) {
//         movefile.unixmove(apath, netpiepath, (res) => {
//             gitadd(netpiepath, (res) => {
//                 gitcommit(netpiepath, 'add a', (res) => {
//                     gitpush(netpiepath, (res) => {

//                     })
//                 })
//             })
//         })
//     }
// })