#include <stdio.h>
#include <string.h>
#include <string>
#include <math.h>
#include "esp_system.h"
#include "kidbright32.h"
#include "driver/uart.h"
#include "soc/uart_struct.h"
#include "STRA.h"

STRA::STRA() {
  polling_ms = STRA_POLLING_MS;
}

void STRA::init(void) {
  state = s_detect;
  initialized = true;
}

int STRA::prop_count(void) {
  // not supported
  return 0;
}

bool STRA::prop_name(int index, char *name) {
  // not supported
  return false;
}

bool STRA::prop_unit(int index, char *unit) {
  // not supported
  return false;
}

bool STRA::prop_attr(int index, char *attr) {
  // not supported
  return false;
}

bool STRA::prop_read(int index, char *value) {
  // not supported
  return false;
}

bool STRA::prop_write(int index, char *value) {
  // not supported
  return false;
}

void STRA::process(Driver *drv) {
//  char buffer[64];
//  sprintf(buffer, "%lldms\n", (esp_timer_get_time() / 1000));
//  uart_write_bytes(UART_NUM_0, (const char*)buffer, strlen(buffer));
}


char* STRA::random() {
    return "nat-random";
}

char* STRA::to_char_array(double num_double, int decimal_place)
{
    int num_int = round(num_double * pow(10, decimal_place));
    int sign = num_int < 0 ? 1 : 0;
    num_int = abs(num_int);

    if (num_int == 0)
    {
        char* s = (char*)malloc(decimal_place + 3);
        s[0] = '0';
        s[1] = '.';
        for (int i = 2; i < decimal_place + 2; i++)
            s[i] = '0';
        s[decimal_place + 2] = '\0';
        return s;
    }

    int digit_count = 1;
    int n = num_int;
    if (n >= 100000000) { digit_count += 8; n /= 100000000; }
    if (n >= 10000) { digit_count += 4; n /= 10000; }
    if (n >= 100) { digit_count += 2; n /= 100; }
    if (n >= 10) { digit_count++; }

    int size = digit_count + 1 + (decimal_place > 0 ? 1 : 0) + sign;
    char* s = (char*)malloc(size);

    for (int i = 0, integer = num_int; integer != 0; integer /= 10) {
        s[size - 2 - i++] = integer % 10 + 48;
        if (decimal_place > 0 && i == decimal_place)
            s[size - 2 - i++] = '.';
    }
    s[size - 1] = '\0';
    if (sign)
        s[0] = '-';
    return s;

    //Fix when '.5' happened will become to 0.5

    if (s[0] == '.') {
        char* x = (char*)malloc(size + 1);
        x[0] = '0';
        for (int i = 0; i < strlen(s); i++) {
            x[i+1] = s[i];
        }
        x[size + 1] = '\0';
        printf("%s\n", x);
        return x;
    }

    //Fix when '-.5' happened will become to -0.5
    
    if (s[0] == '-' && s[1] == '.') {
        char* x = (char*)malloc(size + 1);
        x[0] = '-';
        x[1] = '0';
        for (int i = 0; i < strlen(s) - 1; i++) {
            x[i+2] = s[i + 1];
        }
        x[size + 1] = '\0';
        printf("%s\n", x);
        return x;
    }

}

char* STRA::concat(char one[], char two[]) {
    char * newArray = new char[strlen(one)+strlen(two)+1];
    strcpy(newArray,one);
    strcat(newArray,two);
    return newArray;
    // char str[80] = "test";
    // strcpy (str,one);
    // strcat (str,two);
    // printf("%s\n", str);
    // return str;

    // std::string total(std::string(one) + two);
    // char* result = const_cast<char*>(total.c_str());
    // printf("%s\n", result);
    // return result;
}

// char* STRA::concat(double one, char *two) {
    // char* char_one = STRA::to_char_array(one, 3);
    // std::string total(std::string(char_one) + two);
    // char* result = const_cast<char*>(total.c_str());
    // printf("%s\n", result);
    // return result;
// }

// char* STRA::concat(char *one, double two) {
    // char* char_two = STRA::to_char_array(two, 3);
    // std::string total(std::string(one) + char_two);
    // char* result = const_cast<char*>(total.c_str());
    // return result;
// }

// char* STRA::concat(double one, double two) {
    // char* char_one = STRA::to_char_array(one, 3);
    // char* char_two = STRA::to_char_array(one, 3);
    // std::string total(std::string(char_one) + char_two);
    // char* result = const_cast<char*>(total.c_str());
    // printf("%s\n", result);
    // return result;
// }

char* STRA::number_to_string(double number) {
    // char buf[5];
    return STRA::to_char_array(number, 2);
    // return gcvt(number, 5, buf);
}

