#ifndef __L298N_M2_H__
#define __L298N_M2_H__

#include "driver.h"
#include "device.h"

class L298N_M2 : public Device {
	private:
		enum {
			s_detect, s_idle, s_error, s_wait
		} state;
		TickType_t tickcnt;
		// method
		void init_gpio(gpio_num_t gpio, int val);
		int cmpr_calc(int duty);
		void l298n_m2_stop(void);

	public:
		const char *TAG = "l298n_m2";
		// constructor
		L298N_M2(void);
		// override
		void init(void);
		void process(Driver *drv);
		int prop_count(void);
		bool prop_name(int index, char *name);
		bool prop_unit(int index, char *unit);
		bool prop_attr(int index, char *attr);
		bool prop_read(int index, char *value);
		bool prop_write(int index, char *value);
		// method
		void spin(int speed); // spin at specific speed
		void stop(void); // stop motor drive
};

#endif
