Blockly.Blocks["l298n_m2.spin"] = {
	init: function() {
		this.appendDummyInput()
			.appendField(Blockly.Msg.L298N_M2_SPIN_TITLE);

		this.appendDummyInput()
			.appendField(Blockly.Msg.MOTOR_SPEED)
		this.appendValueInput("SPEED").setCheck("Number");
		this.appendDummyInput()
			.appendField('%');

		this.setInputsInline(true);
		this.setPreviousStatement(true);
		this.setNextStatement(true);
		this.setColour(160);
		this.setTooltip(Blockly.Msg.L298N_M2_SPIN_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.L298N_M2_SPIN_HELPURL);
	},
	// custom xmlToolbox
	xmlToolbox: function() {
		return $(document.createElement('block')).attr({
			type: 'l298n_m2.spin'
		}).append('\
		   <value name="SPEED">\
			   <shadow type="l298n_m2.speed_number">\
			   </shadow>\
		   </value>'
	   );
   }
};

Blockly.Blocks["l298n_m2.stop"] = {
	init: function() {
		this.appendDummyInput()
			.appendField(Blockly.Msg.L298N_M2_STOP_TITLE);

		this.setPreviousStatement(true);
		this.setNextStatement(true);
		this.setColour(160);
		this.setTooltip(Blockly.Msg.L298N_M2_STOP_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.L298N_M2_STOP_HELPURL);
	}
};

// hidden block (no generator defined), temporary used for shadow block
Blockly.Blocks["l298n_m2.speed_number"] = {
	init: function() {
		this.appendDummyInput()
			.appendField(new Blockly.FieldNumber(50, 0, 100, 1), 'VALUE');
		this.setOutput(true, 'Number');
		this.setPreviousStatement(false);
		this.setNextStatement(false);
		this.setColour(math_colour);
		this.setTooltip(Blockly.Msg.L298N_M2_SPEED_NUMBER_TOOLTIP);
		this.setHelpUrl(Blockly.Msg.L298N_M2_SPEED_NUMBER_HELPURL);
	},
	// custom xmlToolboxcolumn
	xmlToolbox: function() {
		return null; // hidden block
	}
};

