function doGet(e){
  Logger.log("--- doGet ---");
 
 var s1 = "",
     s2 = "",
     s3 = "",
     s4 = "";
 
  try {
 
    // this helps during debuggin
    if (e == null){e={}; e.parameters = {s1:"test",s2:"-1"};}
    s1 = e.parameters.s1;
    s2 = e.parameters.s2;
    s3 = e.parameters.s3;
    s4 = e.parameters.s4;
    // save the data to spreadsheet
    save_data(s1, s2, s3, s4);
    return ContentService.createTextOutput("Wrote:\n  s1: " + s1 + "\n  s2: " + s2 + "\n  s3: " + s3+ "\n  s4: " + s4);
 
  } catch(error) { 
    Logger.log(error);    
    return ContentService.createTextOutput("oops...." + error.message 
                                            + "\n" + new Date() 
                                            + "\ns1: " + s1 +
                                            + "\ns2: " + s2);
  }  
}
 
// Method to save given data to a sheet
function save_data(s1, s2, s3, s4){
  Logger.log("--- save_data ---"); 
  try {
    var dateTime = new Date();
    // Paste the URL of the Google Sheets starting from https thru /edit
    // For e.g.: https://docs.google.com/..../edit 
    var ss = SpreadsheetApp.openByUrl("https://docs.google.com/spreadsheets/d/15R3Sls5LL2bMuJaUQF8UpqZUkBwtPS9Y4NOA9ohawHA/edit");
    var dataLoggerSheet = ss.getSheetByName("sheet1");
    var cur_Time = Utilities.formatDate(dateTime, "Asia/Bangkok", 'HH:mm:ss');

    // Get last edited row from DataLogger sheet
    var row = dataLoggerSheet.getLastRow() + 1;
 
    // Start Populating the data
    dataLoggerSheet.getRange("A" + row).setValue(dateTime); // date
    dataLoggerSheet.getRange("B" + row).setValue(cur_Time); // Time
    dataLoggerSheet.getRange("C" + row).setValue(s1); // s1
    dataLoggerSheet.getRange("D" + row).setValue(s2); // s2
    dataLoggerSheet.getRange("E" + row).setValue(s3); // s3
    dataLoggerSheet.getRange("F" + row).setValue(s4); // s4
  }
 
  catch(error) {
    Logger.log(JSON.stringify(error));
  }
 
  Logger.log("--- save_data end---"); 
}
