#ifndef __KBGSHEET_CPP__
#define __KBGSHEET_CPP__

#include "kbgsheet.h"

KBGSHEET::KBGSHEET() {}

void KBGSHEET::init(void)
{
	esp_log_level_set("*", ESP_LOG_INFO);

	memset(this->value, 0, sizeof value);

	// clear error flag
	error = false;
	// set initialized flag
	initialized = true;
}

int KBGSHEET::prop_count(void)
{
	return 0;
}

bool KBGSHEET::prop_name(int index, char *name)
{
	// not supported
	return false;
}

bool KBGSHEET::prop_unit(int index, char *unit)
{
	// not supported
	return false;
}

bool KBGSHEET::prop_attr(int index, char *attr)
{
	// not supported
	return false;
}

bool KBGSHEET::prop_read(int index, char *value)
{
	// not supported
	return false;
}

bool KBGSHEET::prop_write(int index, char *value)
{
	// not supported
	return false;
}

void KBGSHEET::process(Driver *drv)
{
}

void KBGSHEET::set(uint8_t n, char *value)
{
	strcpy(this->value[n - 1], value);
}

void KBGSHEET::set(uint8_t n, double value)
{
	sprintf(this->value[n - 1], "%0.1f", value);
}

void KBGSHEET::set(uint8_t n, int value)
{
	itoa(value, this->value[n - 1], 10);
}

void KBGSHEET::set(uint8_t n, bool value)
{
	this->value[n - 1][0] = value ? '1' : '0';
	this->value[n - 1][1] = 0;
}

bool KBGSHEET::send(char *url, char *data)
{
	// Use esp http api
	esp_http_client_config_t config = {.url = url};
	esp_http_client_handle_t client = esp_http_client_init(&config);
	esp_http_client_set_method(client, HTTP_METHOD_GET);
//	esp_http_client_set_post_field(client, data, strlen(data));
//	esp_http_client_set_header(client, "Content-Type", "application/json");

//	ESP_LOGI("KBGSHEET", "Data: %s, len: %d", data, strlen(data));

	esp_err_t err = esp_http_client_perform(client);
	bool error;
	if (err == ESP_OK)
	{
		uint16_t len = esp_http_client_get_content_length(client);
		uint16_t code = esp_http_client_get_status_code(client);

		ESP_LOGI("KBGSHEET", "HTTPS Status = %d, content_length = %d", code, len);
		error = false;
	}
	else
	{
		ESP_LOGE("KBGSHEET", "Error perform http request %s", esp_err_to_name(err));
		error = true;
	}
	esp_http_client_cleanup(client);
	return error;
}

bool KBGSHEET::sendSensor(char *host, char *type, double val)
{
	bool error;
	char *url = (char *)malloc(200);
	memset(url, 0, 200);

	sprintf(url, "https://script.google.com/macros/s/AKfycbwD1Xq_oKm-PigcPW23xDPWO7ZjiMmeQFc8OrfygYBL96D1EuGfwrxl97Cu04Cf15_7jA/exec?s1=somphong&s2=supersmart");
	ESP_LOGI("KBGSHEET", "Url: %s", url);

	char *data = (char *)malloc(320);
//	sprintf(data, "{\"mac\":\"%s\",\"dtype\":\"%s\",\"value\":\"%0.1f\"}", host, type, val);
//	sprintf(data, "s1=wut&s2=%0.1f",  val);
	sprintf(data, "?s1=24&s2=36");
	error = send(url,data);
	free(url);
	free(data);
	return error;
}

bool KBGSHEET::sendLocation(char *host, double lat, double lng)
{
	char *url = (char *)malloc(200);
	memset(url, 0, 200);

	sprintf(url, "https://kb.kbgsheet.cloud/io/stream");
	ESP_LOGI("KBGSHEET", "Url: %s", url);

	char *data = (char *)malloc(320);
	sprintf(data, "{\"mac\":\"%s\",\"dtype\":\"gps\",\"value\":\"%f,%f\"}", host, lat, lng);

	// Use esp http api
	esp_http_client_config_t config = {.url = url};
	esp_http_client_handle_t client = esp_http_client_init(&config);
	esp_http_client_set_method(client, HTTP_METHOD_POST);
	esp_http_client_set_post_field(client, data, strlen(data));
	esp_http_client_set_header(client, "Content-Type", "application/json");

	ESP_LOGI("KBGSHEET", "Data: %s, len: %d", data, strlen(data));

	esp_err_t err = esp_http_client_perform(client);
	bool error;
	if (err == ESP_OK)
	{
		uint16_t len = esp_http_client_get_content_length(client);
		uint16_t code = esp_http_client_get_status_code(client);

		ESP_LOGI("KBGSHEET", "HTTPS Status = %d, content_length = %d", code, len);
		error = false;
	}
	else
	{
		ESP_LOGE("KBGSHEET", "Error perform http request %s", esp_err_to_name(err));
		error = true;
	}
	esp_http_client_cleanup(client);

	free(url);
	free(data);
	// memset(value, 0, sizeof value);

	return error;
}

void KBGSHEET::setscr(const char* msg) {
 // 	recv_buff1 = msg;
 	strcpy(recv_buff1,msg);
}

char* KBGSHEET::readscriptid(void) {
  return recv_buff1;
}

void KBGSHEET::send4d(double msg1,double msg2,double msg3,double msg4) {
 // 	recv_buff1 = msg;
 //	strcpy(recv_buff1,mname);
//	int spd1,spd2,spd3,spd4;
	float spd1,spd2,spd3,spd4;
	bool error;
	char *url = (char *)malloc(200);
	memset(url, 0, 200);
	spd1 = msg1;
	spd2 = msg2;
	spd3 = msg3;
	spd4 = msg4;

//	sprintf(recv_buff1, "A%dB%dC%dD%d", spd1,spd2,spd3,spd4);
	sprintf(recv_buff3, "?s1=%0.2f&s2=%0.2f&s3=%0.2f&s4=%0.2f", spd1,spd2,spd3,spd4);
//	sprintf(recv_buff2, "https://script.google.com/macros/s/%s/exec%s", recv_buff1,recv_buff3);
	sprintf(url, "https://script.google.com/macros/s/%s/exec%s", recv_buff1,recv_buff3);
	ESP_LOGI("KBGSHEET", "Url: %s", url);

	char *data2 = (char *)malloc(32);
	sprintf(data2, "?s1=24&s2=36");
	error = send(url,data2);
	free(url);
	free(data2);
//	return error;
}


#endif
