#include "app.h"
#include "uart.h"
#include "debug.h"

static uart_t debug_uart;
static char debug_uart_tx_buffer[1024];
static char debug_uart_rx_buffer[1024];

void debug_init(UART_HandleTypeDef *huart) {
	// init debug_uart structure
	uart_init(&debug_uart, huart, debug_uart_tx_buffer, sizeof(debug_uart_tx_buffer), debug_uart_rx_buffer, sizeof(debug_uart_rx_buffer));
	debug_uart.add_cr_flag = 1;

	// Enable the UART Data Register not empty Interrupts
	//SET_BIT(USART2->CR1, USART_CR1_RXNEIE);
	//NVIC_SetPriority(USART2_IRQn, 1);	// enable debug_uart interrupt
	//NVIC_EnableIRQ(USART2_IRQn);
	//NVIC_DisableIRQ(USART2_IRQn);
}

void debug_putch(char ch) {
	uart_putch(&debug_uart, ch);
}

void debug_put_newline(void) {
	uart_put_newline(&debug_uart);
}

void debug_putchln(char ch) {
	uart_putch(&debug_uart, ch);
	uart_put_newline(&debug_uart);
}

void debug_putstr(const char *str) {
	uart_putstr(&debug_uart, str);
}

void debug_putstrln(const char *str) {
	uart_putstrln(&debug_uart, str);
}

void debug_nibble(uint8_t val) {
	uart_nibble(&debug_uart, val);
}

void debug_nibbleln(uint8_t val) {
	uart_nibbleln(&debug_uart, val);
}

void debug_write(uint8_t val) {
	uart_write(&debug_uart, val);
}

void debug_writeln(uint8_t val) {
	uart_writeln(&debug_uart, val);
}

void debug_write16(uint16_t val) {
	uart_write(&debug_uart, val >> 8);
	uart_write(&debug_uart, val);
}

void debug_write16ln(uint16_t val) {
	uart_write16(&debug_uart, val);
	uart_put_newline(&debug_uart);
}

void debug_write32(uint32_t val) {
	uart_write32(&debug_uart, val);
}

void debug_write32ln(uint32_t val) {
	uart_write32ln(&debug_uart, val);
}

void debug_writedd(uint8_t val) {
	uart_writedd(&debug_uart, val);
}

void debug_writeddln(uint8_t val) {
	uart_writeddln(&debug_uart, val);
}

void debug_writedec(int val) {
	uart_writedec(&debug_uart, val);
}

void debug_writedecln(int val) {
	uart_writedecln(&debug_uart, val);
}

void debug_proc(void) {
	uart_proc(&debug_uart);
}
