#ifndef __DEBUG_H
#define __DEBUG_H

#ifdef __cplusplus
extern "C" {
#endif

#include "app.h"

void debug_putch(char ch);
void debug_put_newline(void);
void debug_putchln(char ch);
void debug_putstr(const char *str);
void debug_putstrln(const char *str);
void debug_nibble(uint8_t val);
void debug_nibbleln(uint8_t val);
void debug_write(uint8_t val);
void debug_writeln(uint8_t val);
void debug_write16(uint16_t val);
void debug_write16ln(uint16_t val);
void debug_write32(uint32_t val);
void debug_write32ln(uint32_t val);
void debug_writedd(uint8_t val);
void debug_writeddln(uint8_t val);
void debug_writedec(int val);
void debug_writedecln(int val);

void debug_init(UART_HandleTypeDef *huart);
void debug_proc(void);

#ifdef __cplusplus
}
#endif

#endif
